
#property indicator_chart_window
#property indicator_buffers 3
#property indicator_color1 RoyalBlue
#property indicator_color2 Red
#property indicator_color3 Crimson

#property indicator_style1 2
#property indicator_style3 2

extern string note1 = "Trend Properties Alert";
int gi_84 = 34;
int gi_88 = 0;
string gs_unused_92 = "0=Simple,1=Exponential";
string gs_unused_100 = "2=Smooth,3=Linear Weighted";
int g_ma_method_108 = MODE_LWMA;
string gs_unused_112 = "0=High/Low,1=Close/Close";
int g_applied_price_120 = PRICE_CLOSE;
string gs_unused_124 = "--------------------------------------------";
string gs_unused_132 = "Filter # default = 2.0";
double gd_140 = 2.0;
extern string note7 = "Draw Dots = true";
extern string note8 = "Draw Lines = false";
extern bool DrawDots = false;
extern string note9 = "--------------------------------------------";
extern int aTake_Profit = 48;
extern int aStop_Loss = 38;
extern string note10 = "--------------------------------------------";
string gs_unused_192 = "turn on Trend Pop-up Alert = true";
extern string note12 = "turn off = false";
extern bool aAlerts = FALSE;
extern string note13 = "--------------------------------------------";
extern string note14 = "send Trend Email Alert = true";
extern string note15 = "turn off = false";
bool gi_236 = FALSE;
bool gi_240 = FALSE;
bool gi_244 = FALSE;
double g_ibuf_248[];
double g_ibuf_252[];
double g_ibuf_256[];
double g_ibuf_260[];
int gi_264;
string gs_268;
int g_time_276 = 0;

string GetTimeFrameStr() {
   string l_timeframe_4;
   switch (Period()) {
   case PERIOD_M1:
      l_timeframe_4 = "M1";
      break;
   case PERIOD_M5:
      l_timeframe_4 = "M5";
      break;
   case PERIOD_M15:
      l_timeframe_4 = "M15";
      break;
   case PERIOD_M30:
      l_timeframe_4 = "M30";
      break;
   case PERIOD_H1:
      l_timeframe_4 = "H1";
      break;
   case PERIOD_H4:
      l_timeframe_4 = "H4";
      break;
   case PERIOD_D1:
      l_timeframe_4 = "D1";
      break;
   case PERIOD_W1:
      l_timeframe_4 = "W1";
      break;
   case PERIOD_MN1:
      l_timeframe_4 = "MN1";
      break;
   default:
      l_timeframe_4 = Period();
   }
   return (l_timeframe_4);
}

int init() {
   IndicatorBuffers(4);
   if (!SetIndexBuffer(0, g_ibuf_248) && !SetIndexBuffer(1, g_ibuf_252) && !SetIndexBuffer(2, g_ibuf_256) && !SetIndexBuffer(3, g_ibuf_260)) Print("cannot set indicator buffers!");
   if (DrawDots) {
      SetIndexStyle(0, DRAW_ARROW);
      SetIndexStyle(1, DRAW_ARROW);
      SetIndexStyle(2, DRAW_ARROW);
      SetIndexArrow(0, 158);
      SetIndexArrow(1, 158);
      SetIndexArrow(2, 158);
   } else {
      SetIndexStyle(0, DRAW_LINE, STYLE_DOT, 0);
      SetIndexStyle(1, DRAW_LINE, STYLE_DOT, 0);
      SetIndexStyle(2, DRAW_LINE, STYLE_DOT, 0);
   }
   gi_264 = gi_84 + MathFloor(MathSqrt(gi_84));
   SetIndexDrawBegin(0, gi_264);
   SetIndexDrawBegin(1, gi_264);
   SetIndexDrawBegin(2, gi_264);
   IndicatorDigits(MarketInfo(Symbol(), MODE_DIGITS) + 1.0);
   IndicatorShortName("FxSoni Entry");
   SetIndexLabel(0, "FxSoni Entry");
   gs_268 = Symbol() + " (" + GetTimeFrameStr() + "):  ";
   return (0);
}

int start() {
   double l_ima_on_arr_20;
   int li_8 = IndicatorCounted();
   if (li_8 < 1) {
      for (int li_4 = 1; li_4 <= gi_264; li_4++) g_ibuf_260[Bars - li_4] = 0;
      for (li_4 = 1; li_4 <= gi_84; li_4++) {
         g_ibuf_248[Bars - li_4] = 0;
         g_ibuf_252[Bars - li_4] = 0;
         g_ibuf_256[Bars - li_4] = 0;
      }
   }
   if (li_8 > 0) li_8--;
   int li_0 = Bars - li_8;
   for (li_4 = 0; li_4 < li_0; li_4++) g_ibuf_260[li_4] = 2.0 * iMA(NULL, 0, MathFloor(gi_84 / gd_140), gi_88, g_ma_method_108, g_applied_price_120, li_4) - iMA(NULL, 0, gi_84, gi_88, g_ma_method_108, g_applied_price_120, li_4);
   double l_ima_on_arr_12 = iMAOnArray(g_ibuf_260, 0, MathFloor(MathSqrt(gi_84)), 0, g_ma_method_108, 0);
   for (li_4 = 1; li_4 < li_0; li_4++) {
      l_ima_on_arr_20 = iMAOnArray(g_ibuf_260, 0, MathFloor(MathSqrt(gi_84)), 0, g_ma_method_108, li_4);
      if (l_ima_on_arr_20 > l_ima_on_arr_12) {
         g_ibuf_248[li_4] = EMPTY_VALUE;
         g_ibuf_252[li_4] = EMPTY_VALUE;
         g_ibuf_256[li_4] = l_ima_on_arr_20;
         g_ibuf_256[li_4 - 1] = l_ima_on_arr_12;
      } else {
         if (l_ima_on_arr_20 < l_ima_on_arr_12) {
            g_ibuf_248[li_4] = l_ima_on_arr_20;
            g_ibuf_248[li_4 - 1] = l_ima_on_arr_12;
            g_ibuf_252[li_4] = EMPTY_VALUE;
            g_ibuf_256[li_4] = EMPTY_VALUE;
         } else {
            g_ibuf_248[li_4] = -1;
            g_ibuf_252[li_4] = l_ima_on_arr_20;
            g_ibuf_256[li_4 - 1] = l_ima_on_arr_12;
            g_ibuf_256[li_4] = -1;
         }
      }
      if (aAlerts) {
         if (l_ima_on_arr_20 < l_ima_on_arr_12) {
            if (!gi_240) {
               if (BarChanged()) {
                  Alert(gs_268 + "Trend " + aRperiodf() + " Alert\nBUY signal @ Ask = $", Ask, "; Bid = $", Bid, 
                  "\nDate & Time = ", TimeToStr(TimeCurrent(), TIME_DATE), " ", TimeHour(TimeCurrent()), ":", TimeMinute(TimeCurrent()));
                  PlaySound("alert.wav");
                  if (gi_236) {
                     SendMail(gs_268, "Trend Alert\nBUY signal @ Ask = $" + DoubleToStr(Ask, 4) + ", Bid = $" + DoubleToStr(Bid, 4) + ", Date & Time = " + TimeToStr(TimeCurrent(), TIME_DATE) +
                        " " + TimeHour(TimeCurrent()) + ":" + TimeMinute(TimeCurrent()) + "  Stop:  " + DoubleToStr(aGetSLl(), 4) + "  Limit:  " + DoubleToStr(aGetTPl(), 4));
                  }
               }
               gi_240 = TRUE;
               gi_244 = FALSE;
            }
         }
         if (l_ima_on_arr_20 > l_ima_on_arr_12) {
            if (!gi_244) {
               if (BarChanged()) {
                  Alert(gs_268 + "Trend Alert\nSELL signal @ Ask = $", Ask, "; Bid = $", Bid, 
                  "\nDate & Time = ", TimeToStr(TimeCurrent(), TIME_DATE), " ", TimeHour(TimeCurrent()), ":", TimeMinute(TimeCurrent()));
                  PlaySound("alert.wav");
                  if (gi_236) {
                     SendMail(gs_268, "Trend Alert\nSELL signal @ Ask = $" + DoubleToStr(Ask, 4) + ", Bid = $" + DoubleToStr(Bid, 4) + ", Date & Time = " + TimeToStr(TimeCurrent(), TIME_DATE) +
                        " " + TimeHour(TimeCurrent()) + ":" + TimeMinute(TimeCurrent()) + "  Stop:  " + DoubleToStr(aGetSLs(), 4) + "  Limit:  " + DoubleToStr(aGetTPs(), 4));
                  }
               }
               gi_244 = TRUE;
               gi_240 = FALSE;
            }
         }
      }
      l_ima_on_arr_12 = l_ima_on_arr_20;
   }
   return (0);
}

bool BarChanged() {
   if (g_time_276 != Time[0]) {
      g_time_276 = Time[0];
      return (TRUE);
   }
   return (FALSE);
}

double aGetTPs() {
   return (Bid - aTake_Profit * Point);
}

double aGetTPl() {
   return (Ask + aTake_Profit * Point);
}

double aGetSLs() {
   return (Bid + aStop_Loss * Point);
}

double aGetSLl() {
   return (Ask - aStop_Loss * Point);
}

int aRperiodf() {
   return (10000.0 * (gi_84 * Point));
}